implementation module Window2;

import	StdClass,StdInt,StdBool,StdString;
import	windows, quickdraw;
import	commonDef, windowDevice, windowAccess;
import ScrollBars;

//	General rules:

WindowGetScrolls :: !Window -> (!Int, !Int);
WindowGetScrolls (_,(_,hScroll,_),(_,vScroll,_),_,_,_) = (hScroll, vScroll);

WindowSetScrolls :: !Window !Int !Int -> Window;
WindowSetScrolls (wPtr, (hControl,_,hMax), (vControl,_,vMax), pict, updArea, zoom) hScroll vScroll
	= (wPtr, (hControl, hScroll, hMax), (vControl, vScroll, vMax), pict, updArea, zoom);

WindowGetThumbs	:: !Window !*Toolbox -> (!(!Int, !Int), !*Toolbox);
WindowGetThumbs (_,(hControl,_,h_max),(vControl,_,v_max),_,_,_) tb
	=	((hThumb, vThumb), tb2);
	where {
		(hThumb, tb1) = GetScrollBarValue hControl h_max tb;
		(vThumb, tb2) = GetScrollBarValue vControl v_max tb1;
	};

::	ReadWindowHandle			*s x	:==	(WindowHandle s)
												-> *Toolbox
												-> *(!x, !*Toolbox);
::	DeltaState_and_WindowHandle *s		:==	s	-> *((WindowHandle s)
												-> *(*Toolbox
												-> *(!s, !WindowHandle s, !*Toolbox)));
::	DeltaState_and_WindowHandles *s		:==	s	-> *([WindowHandle s]
												-> *(*Toolbox
												-> *(!s, ![WindowHandle s], !*Toolbox)));


WindowIdOK :: WindowId -> Bool;
WindowIdOK _ = True;

ChangeState_and_Windows	:: !(DeltaState_and_WindowHandles *s) !*s !(IOState *s) -> (!*s, !IOState *s);
ChangeState_and_Windows f s ioState
	= 	(s1, IOStateSetDevice (IOStateSetToolbox tb1 ioState2) windows1);
	where {
		(windows, ioState1)	= IOStateGetDevice  ioState WindowDevice;
		(tb, ioState2)		= IOStateGetToolbox ioState1;
		(wHs, cursor)		= WindowSystemState_WindowHandles windows;
		(s1, wHs1, tb1)		= f s wHs tb;
		windows1			= WindowSystemState (wHs1, cursor);
	};

ChangeState_and_Window :: !(Cond WindowId) !(DeltaState_and_WindowHandle *s) !*s !(IOState *s)
	->	(!*s, !IOState *s);
ChangeState_and_Window cond f s ioState
	= 	ChangeState_and_Windows (ChangeState_and_WindowHandles cond f) s ioState;

ChangeState_and_WindowHandles :: !(Cond WindowId) !(DeltaState_and_WindowHandle *s)
			 !*s  ![WindowHandle *s] !*Toolbox
		->	(!*s, ![WindowHandle *s],!*Toolbox);
ChangeState_and_WindowHandles cond f s [wH=:(wDef, window) : wHs] tb
|	cond (WindowDefGetWindowId wDef)	= (s1, [wH1 : wHs ], tb1);
										= (s2, [wH  : wHs1], tb2);
	where {
		(s1, wH1,  tb1) = f s wH tb;
		(s2, wHs1, tb2) = ChangeState_and_WindowHandles cond f s wHs tb;
	};
ChangeState_and_WindowHandles _ _ s wHs tb = (s, wHs, tb);


ReadWindow :: !(Cond WindowId) !(ReadWindowHandle s x) x !(IOState s) -> (!x, !IOState s);
ReadWindow cond f x ioState
	=	(x1, IOStateSetToolbox tb1 ioState2);
	where {
		(windows,ioState1)	= IOStateGetDevice ioState WindowDevice;
		(tb,	 ioState2)	= IOStateGetToolbox ioState1;
		(wHs,	 cursor)	= WindowSystemState_WindowHandles windows;
		(x1,	 tb1)		= ReadWindowHandles cond f x wHs tb;
	};

ReadWindowHandles :: !(Cond WindowId) !(ReadWindowHandle s x) x ![WindowHandle s] !*Toolbox
	-> (x, !*Toolbox);
ReadWindowHandles cond f x [wH=:(wDef, window) : wHs] tb
|	cond (WindowDefGetWindowId wDef)	= f wH tb;
										= ReadWindowHandles cond f x wHs tb;
ReadWindowHandles _ _ x _ tb = (x, tb);


/*	Changing the values of both scrollbars:
		the new thumbvalues are always adjusted to their extreme values: if the thumb is less than
		its corresponding PictureDomain minimum, it is set to the PictureDomain minimum. If the
		thumb is larger than its corresponding PictureDomain maximum minus the current window
		size, it is set to this latter value.
		The new scrollvalues are adjusted between one and the difference of the corresponding
		PictureDomain extremes.
*/


::	ScrollBarChange
	=	ChangeThumbs	Int Int | ChangeHThumb	Int | ChangeVThumb  Int
	|	ChangeScrolls	Int Int | ChangeHScroll	Int | ChangeVScroll Int
	|	ChangeHBar		Int Int | ChangeVBar	Int Int;


ChangeScrollBar	:: !WindowId !ScrollBarChange !*s !(IOState *s) -> (!*s, !IOState *s);
ChangeScrollBar id change s ioState
	=	ChangeState_and_Window ((==) id) (WindowHandleChangeScrollBar change) s ioState;

ChangeActiveScrollBar :: !ScrollBarChange !*s !(IOState *s) -> (!*s, !IOState *s);
ChangeActiveScrollBar change s ioState
	=	ChangeState_and_Window WindowIdOK (WindowHandleChangeScrollBar change) s ioState;

WindowHandleChangeScrollBar :: !ScrollBarChange !*s !(WindowHandle *s) !*Toolbox
	->	(!*s, ! WindowHandle *s, !*Toolbox);
WindowHandleChangeScrollBar change s wH=:(wDef, window) tb
|	not (IsScrollWindow wDef)	= (s,		wH,					tb );
|	OnlyThumbsChange  change	= (sThumbs,	(wDef, wThumbs ),	tb1);
|	OnlyScrollsChange change	= (sScrolls,(wDef, wScrolls),	tb2);
								= (sBar,	(wDef, wBar),		tb3);
	where {
		updateF							= WindowDefGetUpdate wDef;
		(wThumbs,	sThumbs,	tb1)	= Change_thumbs		change wH updateF s tb;
		(wScrolls,	sScrolls,	tb2)	= Change_scrolls	change wH updateF s tb;
		(wBar,		sBar,		tb3)	= Change_bar		change wH updateF s tb;
	};

Change_thumbs :: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Change_thumbs change wH=:(wDef, window) f s tb
|	ThumbsChange change		= WindowSetThumbs window newH newV oldH oldV size f s tb2;
|	HThumbChange change		= WindowSetThumbs window newH oldV oldH oldV size f s tb2;
							= WindowSetThumbs window oldH newV oldH oldV size f s tb2;
	where {
		(w, h)				= size;
		(size,	tb1)		= WindowGetFrameSize wH tb;
		(oldH,	oldV)		= thumbs;
		(thumbs,	tb2)	= WindowGetThumbs window tb1;
		newH				= Max hMin (Min modHval hMax`);
		newV				= Max vMin (Min modVval vMax`);
		modHval				= Align_thumb hVal hMin hMax` hScroll;
		modVval				= Align_thumb vVal vMin vMax` vScroll;
		(hScroll, vScroll)	= WindowGetScrolls window;
		(hVal, vVal)		= ChangeValues change;
		(hMin, vMin)		= topLeft;
		(hMax, vMax)		= rightDown; 
		(topLeft, rightDown)= WindowDefGetPictureDomain wDef;
		hMax`				= hMax - w;
		vMax`				= vMax - h;
	};

Change_scrolls :: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Change_scrolls change wH=:(wDef, window) f s tb
|	ScrollsChange change	= (WindowSetScrolls wThumbs newHs newVs, sThumbs, tbHV);
|	HScrollChange change	= (WindowSetScrolls wHThumb newHs oldVs, sHThumb, tbH );
							= (WindowSetScrolls wVThumb oldHs newVs, sVThumb, tbV );
	where {
		(wThumbs, sThumbs, tbHV)= WindowSetThumbs window newHt newVt oldHt oldVt size f s tb2;
		(wHThumb, sHThumb, tbH )= WindowSetThumbs window newHt oldVt oldHt oldVt size f s tb2;
		(wVThumb, sVThumb, tbV )= WindowSetThumbs window oldHt newVt oldHt oldVt size f s tb2;
		(w, h)					= size;
		(size,		tb1)		= WindowGetFrameSize wH tb;
		(oldHt,		oldVt)		= oldThumbs;
		(oldThumbs,	tb2)		= WindowGetThumbs window tb1;
		newHs					= Max 1 (Min hVal (hMax - hMin));
		newVs					= Max 1 (Min vVal (vMax - vMin));
		newHt					= Max hMin (Min modHt hMax`);
		newVt					= Max vMin (Min modVt vMax`);
		modHt					= Align_thumb oldHt hMin hMax` newHs;
		modVt					= Align_thumb oldVt vMin vMax` newVs;
		(oldHs, oldVs)			= WindowGetScrolls window;
		(hVal, vVal)			= ChangeValues change;
		(hMin, vMin)			= topLeft;
		(hMax, vMax)			= rightDown; 
		(topLeft, rightDown)	= WindowDefGetPictureDomain wDef;
		hMax`					= hMax - w;
		vMax`					= vMax - h;
	};
	
Change_bar :: !ScrollBarChange !(WindowHandle *s) !(UpdateFunction *s) !*s !*Toolbox
	->	(!Window, !*s, !*Toolbox);
Change_bar (ChangeHBar thumb scroll) wH=:(wDef, window) f s tb
	=	Change_thumbs (ChangeHThumb thumb) (wDef, wScroll) f sScroll tbScroll;
	where {
		(wScroll, sScroll, tbScroll) = Change_scrolls (ChangeHScroll scroll) wH f s tb;
	};
Change_bar (ChangeVBar thumb scroll) wH=:(wDef, window) f s tb
	=	Change_thumbs (ChangeVThumb thumb) (wDef, wScroll) f sScroll tbScroll;
	where {
		(wScroll, sScroll, tbScroll) = Change_scrolls (ChangeVScroll scroll) wH f s tb;
	};

OnlyThumbsChange :: !ScrollBarChange	-> Bool;
OnlyThumbsChange (ChangeThumbs _ _)		= True;
OnlyThumbsChange (ChangeHThumb _)		= True;
OnlyThumbsChange (ChangeVThumb _)		= True;
OnlyThumbsChange _						= False;

OnlyScrollsChange :: !ScrollBarChange	-> Bool;
OnlyScrollsChange (ChangeScrolls _ _)	= True;
OnlyScrollsChange (ChangeHScroll _)		= True;
OnlyScrollsChange (ChangeVScroll _)		= True;
OnlyScrollsChange _						= False;

ThumbsChange :: !ScrollBarChange		-> Bool;
ThumbsChange (ChangeThumbs _ _)			= True;
ThumbsChange _							= False;

HThumbChange :: !ScrollBarChange		-> Bool;
HThumbChange (ChangeHThumb _)			= True;
HThumbChange _							= False;
	
ScrollsChange :: !ScrollBarChange		-> Bool;
ScrollsChange (ChangeScrolls _ _)		= True;
ScrollsChange _							= False;

HScrollChange :: !ScrollBarChange -> Bool;
HScrollChange (ChangeHScroll _)			= True;
HScrollChange _							= False;
	
ChangeValues :: !ScrollBarChange -> (Int, Int);
ChangeValues (ChangeThumbs  h v) = ( h, v);
ChangeValues (ChangeHThumb  h  ) = ( h, -1);
ChangeValues (ChangeHScroll h  ) = ( h, -1);
ChangeValues (ChangeScrolls h v) = ( h, v);
ChangeValues (ChangeVThumb    v) = (-1, v);
ChangeValues (ChangeVScroll   v) = (-1, v);
ChangeValues (ChangeHBar    t s) = ( t, s);
ChangeValues (ChangeVBar    t s) = ( t, s);


//	Changing the (active) PictureDomain:

ChangePictureDomain	:: !WindowId !PictureDomain !*s !(IOState *s) -> (!*s, !IOState *s);
ChangePictureDomain id pictDomain s ioState
|	ValidPictureDomain pictDomain
	=	ChangeState_and_Windows (ChangePictureDomain` ((==) id) pictDomain (-1)) s ioState;
	=	(s, ioState);

ChangeActivePictureDomain :: !PictureDomain !*s !(IOState *s) -> (!*s, !IOState *s);
ChangeActivePictureDomain pictDomain s ioState
|	ValidPictureDomain pictDomain
	=	ChangeState_and_Windows (ChangePictureDomain` WindowIdOK pictDomain (-1)) s ioState;
	=	(s, ioState);

ChangePictureDomain` :: !(Cond WindowId) !PictureDomain !WindowPtr !*s ![WindowHandle *s] !*Toolbox
	->	(!*s, ![WindowHandle *s],!*Toolbox);
ChangePictureDomain` cond pictDomain prevWindow s [wH=:(wDef, window) : wHs] tb
|	not (cond (WindowDefGetWindowId wDef))	= (s_wHs1,	[wH					: wHs`], tb1);
|	IsScrollWindow wDef						= (s1,		[(wDef1, window1)	: wHs ], tb2);
											= (s,		[wH1				: wHs ], tb3);
	where {
		wPtr				= WindowGetPtr window;
		(s_wHs1, wHs`,tb1)	= ChangePictureDomain` cond pictDomain wPtr s wHs tb;
		(window1, s1, tb2)	= Set_window_domain window pictDomain updateF s tb;
		(wH1, tb3)			= Change_fixed_window_domain pictDomain prevWindow (wDef1, window) tb;
		wDef1				= WindowDefSetPictureDomain pictDomain (
									WindowDefSetMinimumSize (Min minW dX, Min minH dY) wDef);
		(pDMin, pDMax)		= pictDomain;
		(xMin,yMin)			= pDMin;
		(xMax,yMax)			= pDMax;
		dX					= xMax - xMin;
		dY					= yMax - yMin;
		(minW, minH)		= WindowDefGetMinimumSize	wDef;
		updateF				= WindowDefGetUpdate		wDef;
	};
ChangePictureDomain` cond pictDomain prevWindow s w_and_hs tb = (s, w_and_hs, tb);

ValidPictureDomain :: !PictureDomain -> Bool;
ValidPictureDomain ((xMin, yMin), (xMax, yMax)) = xMin < xMax && yMin < yMax;

		
/*	WindowGetFrame yields the visible part of the Picture in the (active) window.
	In case the WindowId is unknown, ((0,0),(0,0)) is returned.
*/

WindowGetFrame :: !WindowId !(IOState *s) -> (!PictureDomain, !IOState *s);
WindowGetFrame id ioState = ReadWindow ((==) id) WindowHandleGetFrame ((0,0),(0,0)) ioState;

ActiveWindowGetFrame :: !(IOState *s) -> (!PictureDomain, !IOState *s);
ActiveWindowGetFrame ioState = ReadWindow WindowIdOK WindowHandleGetFrame ((0,0),(0,0)) ioState;

WindowHandleGetFrame :: !(WindowHandle *s) !*Toolbox -> (!PictureDomain, !*Toolbox);
WindowHandleGetFrame wH=:(_,window) tb
	=	((thumbs, (hThumb + w, vThumb + h)), tb2);
	where {
		(hThumb, vThumb)= thumbs;
		(thumbs,	tb1)= WindowGetThumbs window tb;
		(w, h)			= size;
		(size,	tb2)	= WindowGetFrameSize wH tb1;
	};


/*	WindowGetPos yields the current WindowPos of the (active) window.
	In case the WindowId is unknown, (0,0) is returned.
*/

WindowGetPos :: !WindowId !(IOState *s) -> (!WindowPos, !IOState *s);
WindowGetPos id ioState = ReadWindow ((==) id) WindowHandleGetPos (0,0) ioState;

ActiveWindowGetPos :: !(IOState *s) -> (!WindowPos, !IOState *s);
ActiveWindowGetPos ioState = ReadWindow WindowIdOK WindowHandleGetPos (0,0) ioState;

WindowHandleGetPos :: !(WindowHandle *s) !*Toolbox -> (!WindowPos, !*Toolbox);
WindowHandleGetPos wH tb
	= 	((x-WindowScreenBorder, y-WindowScreenBorder-MenuBarWidth-TitleBarWidth), tb1);
	where {
		(wPos,tb1)	= InGrafport (WindowHandleGetPtr wH) (LocalToGlobal (0,0)) tb;
		(x,y)		= wPos;
	};


/*	Retrieving the active window:
		If the interaction does not contain any windows, the Boolean result is False,
			and the WindowId is 0.
		If the interaction is not active, the Boolean result is also False,
			and the WindowId is of the frontmost window of the interaction.
		Otherwise, the Boolean result is True,
			and the WindowId is of the frontmost window of the interaction.
*/

GetActiveWindow	:: !(IOState *s) -> (!Bool, !WindowId, !IOState *s);
GetActiveWindow ioState
	=	(exists, id, ioState1);
	where {
		(x, ioState1)	= ReadWindow WindowIdOK GetActiveWindowHandle (False, 0) ioState;
		(exists, id)	= x;
	};

GetActiveWindowHandle :: !(WindowHandle *s) !*Toolbox -> (!(!Bool, !WindowId), !*Toolbox);
GetActiveWindowHandle (wDef, window) tb
	=	((frontwPtr == WindowGetPtr window, WindowDefGetWindowId wDef), tb1);
	where {
		(frontwPtr, tb1) = FrontWindow tb;
	};


//	Drawing in the 'visible' part of the (active) windows Picture.

DrawInWindowFrame :: !WindowId !(UpdateFunction *s) !*s !(IOState *s) -> (!*s, !IOState *s);
DrawInWindowFrame id f s ioState
	=	ChangeState_and_Window ((==) id) (DrawInWindowHandleFrame f) s ioState;

DrawInActiveWindowFrame :: !(UpdateFunction *s) !*s !(IOState *s) -> (!*s, !IOState *s);
DrawInActiveWindowFrame f s ioState
	=	ChangeState_and_Window WindowIdOK (DrawInWindowHandleFrame f) s ioState;

DrawInWindowHandleFrame :: !(UpdateFunction *s) !*s !(WindowHandle *s) !*Toolbox
	->	(!*s, ! WindowHandle *s, !*Toolbox);
DrawInWindowHandleFrame f s wH=:(wDef, window) tb
	=	(s1, (wDef, window1), tb3);
	where {
		(size,		tb1)	= WindowGetFrameSize wH tb;
		(thumbs,	tb2)	= WindowGetThumbs window tb1;
		(window1,	tb3)	= Draw_in_window window (WindowDefGetDrawMode wDef) fs tb2;
		(s1, fs)			= f [(thumbs, (hThumb + w, vThumb + h))] s;
		(hThumb, vThumb)	= thumbs;
		(w, h)				= size;
	};
